/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.data.role.IJobHealer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.data.HealerSettings;
import noppes.npcs.util.ValueUtil;

public class JobHealer
extends JobInterface
implements IJobHealer {
    private final Map<Integer, List<EntityLivingBase>> affected = new HashMap<Integer, List<EntityLivingBase>>();
    private final Random rnd = new Random();
    public Map<Integer, HealerSettings> effects = new HashMap<Integer, HealerSettings>();

    public JobHealer(EntityNPCInterface npc) {
        super(npc);
        this.type = JobType.HEALER;
    }

    @Override
    public boolean isWorking() {
        return !this.affected.isEmpty() && this.npc.isAttacking();
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public boolean aiShouldExecute() {
        boolean canAdd = false;
        this.affected.clear();
        for (Integer id : this.effects.keySet()) {
            if (this.npc.totalTicksAlive % (long)this.effects.get((Object)id).speed >= 3L) continue;
            canAdd = true;
            int r = this.effects.get((Object)id).range;
            List list = new ArrayList();
            try {
                list = this.npc.field_70170_p.func_72872_a(EntityLivingBase.class, this.npc.func_174813_aQ().func_72314_b((double)r, (double)r / 2.0, (double)r));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.affected.put(id, list);
            if (this.effects.get((Object)id).onHimself) continue;
            this.affected.get(id).remove((Object)this.npc);
        }
        return canAdd;
    }

    @Override
    public void aiStartExecuting() {
        boolean activated = false;
        for (Integer id : this.affected.keySet()) {
            Potion potion = Potion.func_188412_a((int)id);
            if (potion == null) continue;
            HealerSettings hs = this.effects.get(id);
            if (!hs.isMassive) {
                if (this.affected.get(id).isEmpty()) continue;
                EntityLivingBase entity = null;
                try {
                    List filteredEntities = this.affected.get(id).stream().filter(e -> e.func_70651_bq().stream().noneMatch(effect -> effect.func_188419_a() == potion)).collect(Collectors.toList());
                    if (!filteredEntities.isEmpty()) {
                        entity = (EntityLivingBase)filteredEntities.get(this.rnd.nextInt(filteredEntities.size()));
                    }
                }
                catch (Exception e2) {
                    LogWriter.error(e2);
                }
                if (entity == null) continue;
                boolean isEnemy = this.isEnemy(entity);
                if (hs.type != 2 && (hs.type != 0 || isEnemy) && (hs.type != 1 || !isEnemy)) continue;
                entity.func_70690_d(new PotionEffect(potion, hs.time, hs.amplifier));
                activated = true;
                if (entity == this.npc || CustomNpcs.ShowCustomAnimation && this.npc.animation.isAnimated(AnimationKind.ATTACKING, AnimationKind.INIT, AnimationKind.INTERACT, AnimationKind.DIES)) continue;
                this.npc.func_70671_ap().func_75651_a((Entity)entity, 10.0f, (float)this.npc.func_70646_bf());
                continue;
            }
            for (EntityLivingBase entity : this.affected.get(id)) {
                if ((entity instanceof EntityMob || entity instanceof EntityAnimal) && !hs.possibleOnMobs) continue;
                boolean isEnemy = this.isEnemy(entity);
                if (hs.type != 2 && (hs.type != 0 || isEnemy) && (hs.type != 1 || !isEnemy)) continue;
                entity.func_70690_d(new PotionEffect(potion, hs.time, hs.amplifier));
                activated = true;
            }
        }
        this.affected.clear();
        if (activated) {
            if (!this.npc.func_184614_ca().func_190926_b()) {
                this.npc.func_184609_a(EnumHand.MAIN_HAND);
            } else {
                this.npc.func_184609_a(EnumHand.OFF_HAND);
            }
        }
    }

    @Override
    public void load(NBTTagCompound compound) {
        block3: {
            block2: {
                super.load(compound);
                this.type = JobType.HEALER;
                this.effects.clear();
                if (!compound.func_150297_b("HealerData", 9)) break block2;
                for (int i = 0; i < compound.func_150295_c("HealerData", 10).func_74745_c(); ++i) {
                    HealerSettings hs = new HealerSettings(compound.func_150295_c("HealerData", 10).func_150305_b(i));
                    this.effects.put(hs.id, hs);
                }
                break block3;
            }
            if (!compound.func_150297_b("HealerRange", 3)) break block3;
            int range = compound.func_74762_e("HealerRange");
            int speed = ValueUtil.correctInt(compound.func_74762_e("HealerSpeed"), 10, Integer.MAX_VALUE);
            byte type = compound.func_74771_c("HealerType");
            HashMap<Integer, Integer> oldMap = NBTTags.getIntegerIntegerMap(compound.func_150295_c("BeaconEffects", 10));
            for (int id : oldMap.keySet()) {
                HealerSettings hs = new HealerSettings(id, range, speed, oldMap.get(id), type);
                this.effects.put(hs.id, hs);
            }
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        NBTTagList list = new NBTTagList();
        for (HealerSettings hs : this.effects.values()) {
            list.func_74742_a((NBTBase)hs.writeNBT());
        }
        compound.func_74782_a("HealerData", (NBTBase)list);
        return compound;
    }

    private boolean isEnemy(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return this.npc.faction.isAggressiveToPlayer((EntityPlayer)entity);
        }
        if (entity instanceof EntityNPCInterface) {
            return this.npc.faction.isAggressiveToNpc((EntityNPCInterface)entity);
        }
        return entity instanceof EntityMob;
    }
}

